IF EXISTS(SELECT * FROM sys.views
			WHERE  object_id = OBJECT_ID(N'[dbo].[V_PDV_VD_DEV_NCC]'))
	DROP VIEW [dbo].[V_PDV_VD_DEV_NCC];
GO

--SELECT * FROM V_PDV_VD_DEV_NCC
CREATE VIEW [dbo].[V_PDV_VD_DEV_NCC]
AS
(
SELECT
	NCC.CD_CTR_NCC
	, NCC.CD_EMP
	, NCC.CD_FILIAL
	, NCC.VLR_NCC
	, NCC.CD_USU
	, NCC.DT_CAD
	, NCC.STS_NCC
	, NCC.TIPO_NCC
	, NCC.DT_ULT_ALT
	, NCC.CD_CLI
	, NCC.VLR_NCC_AMORTIZACAO
	, NCC.TP_DEV_TEF_CART_DUP
	, NCC.DT_FECHA_CX
	, NCC.FLAG_CANCELAR_RECBTO
	, NCC.SLD_NCC
	, NCC.DT_CAD_REGISTRO
	, RC_CLI.RZ_CLI
	, RC_CLI.NM_FANT

	, CASE WHEN ISNULL(ParNfe.VALOR, 0) = 0 THEN
		CASE WHEN ISNULL(Par.VALOR, 0) = 0 THEN
			1
		ELSE 
			CASE
				WHEN ISNULL(CONT_NF.CD_VD, 0) = 0 THEN 
					0
				ELSE 
					1
			END
		END 
	ELSE
		CASE WHEN ISNULL(CONT_NF_NFE.CD_NF, 0) = 0 THEN
			0
		ELSE
			1
		END
	END AS CONTEM_NF

	, CASE WHEN ISNULL(ParNfe.VALOR, 0) = 0 THEN
		ISNULL(CONT_NF.CD_NF, 0)
	ELSE
		ISNULL(CONT_NF.CD_NF, 0)
	END AS CD_NF
FROM
	PDV_VD_DEV_NCC AS NCC
	LEFT JOIN PDV_VD_DEV_NCC_PDV_VD_DEV_EST_PROD_IMP AS 
		NCC_DEV ON NCC.CD_CTR_NCC = NCC_DEV.CD_CTR_NCC
	LEFT JOIN PDV_VD ON 
		NCC_DEV.CD_EMP = PDV_VD.CD_EMP
		AND NCC_DEV.CD_FILIAL = PDV_VD.CD_FILIAL
		AND NCC_DEV.CD_VD = PDV_VD.CD_VD
	LEFT JOIN RC_CLI ON 
		PDV_VD.CD_EMP = RC_CLI.CD_EMP
		AND PDV_VD.CD_CLI = RC_CLI.CD_CLI
	LEFT JOIN PDV_VD_DEV_EST_PROD_IMP_EST_NF_ENT CONT_NF ON 
		CONT_NF.CD_EMP = PDV_VD.CD_EMP
		AND CONT_NF.CD_FILIAL = PDV_VD.CD_FILIAL
		AND CONT_NF.CD_VD = PDV_VD.CD_VD
	LEFT JOIN EST_NF_ENT_NFE CONT_NF_NFE ON 
		CONT_NF.CD_EMP = CONT_NF_NFE.CD_EMP
		AND CONT_NF.CD_FILIAL = CONT_NF_NFE.CD_FILIAL
		AND CONT_NF.CD_NF = CONT_NF_NFE.CD_NF
	LEFT OUTER JOIN(
		SELECT
			CD_EMP,
			CD_FILIAL,
			VALOR
		FROM
			PRC_FILIAL_CONFIG
		WHERE
			CD_CHAVE = 'FLAG_NF_DEVO_REQUIS') Par ON
		NCC_DEV.CD_EMP = Par.CD_EMP
		AND NCC_DEV.CD_FILIAL = Par.CD_FILIAL
	LEFT OUTER JOIN(
		SELECT
			CD_EMP,
			CD_FILIAL,
			VALOR
		FROM
			PRC_FILIAL_CONFIG
		WHERE
			CD_CHAVE = 'FLAG_NF_DEVO_REQUIS_NFE') ParNfe ON
		NCC_DEV.CD_EMP = ParNfe.CD_EMP
		AND NCC_DEV.CD_FILIAL = ParNfe.CD_FILIAL

UNION

SELECT
	NCC.CD_CTR_NCC
	, NCC.CD_EMP
	, NCC.CD_FILIAL
	, NCC.VLR_NCC
	, NCC.CD_USU
	, NCC.DT_CAD
	, NCC.STS_NCC
	, NCC.TIPO_NCC
	, NCC.DT_ULT_ALT
	, NCC.CD_CLI
	, NCC.VLR_NCC_AMORTIZACAO
	, NCC.TP_DEV_TEF_CART_DUP
	, NCC.DT_FECHA_CX
	, NCC.FLAG_CANCELAR_RECBTO
	, NCC.SLD_NCC
	, NCC.DT_CAD_REGISTRO
	, RC_CLI.RZ_CLI
	, RC_CLI.NM_FANT

	, CASE WHEN ISNULL(ParNfe.VALOR, 0) = 0 THEN
		CASE WHEN ISNULL(Par.VALOR, 0) = 0 THEN
			1
		ELSE 
			CASE
				WHEN ISNULL(CONT_NF.CD_VD, 0) = 0 THEN 
					0
				ELSE 
					1
			END
		END 
	ELSE
		CASE WHEN ISNULL(CONT_NF_NFE.CD_NF, 0) = 0 THEN
			0
		ELSE
			1
		END
	END AS CONTEM_NF

	, CASE WHEN ISNULL(ParNfe.VALOR, 0) = 0 THEN
		ISNULL(CONT_NF.CD_NF, 0)
	ELSE
		ISNULL(CONT_NF.CD_NF, 0)
	END AS CD_NF
FROM
	PDV_VD_DEV_NCC AS NCC
	INNER JOIN PDV_VD_DEV_NCC_PDV_VD_DEV_EST_PROD_IMP AS NCC_DEV ON 
		NCC.CD_CTR_NCC = NCC_DEV.CD_CTR_NCC
	INNER JOIN PDV_VD ON 
		NCC_DEV.CD_EMP = PDV_VD.CD_EMP
		AND NCC_DEV.CD_FILIAL = PDV_VD.CD_FILIAL
		AND NCC_DEV.CD_VD = PDV_VD.CD_VD
	INNER JOIN RC_CLI ON 
		PDV_VD.CD_EMP = RC_CLI.CD_EMP
		AND PDV_VD.CD_CLI = RC_CLI.CD_CLI
	LEFT JOIN PDV_VD_DEV_EST_PROD_IMP_EST_NF_ENT CONT_NF ON 
		CONT_NF.CD_EMP = PDV_VD.CD_EMP
		AND CONT_NF.CD_FILIAL = PDV_VD.CD_FILIAL
		AND CONT_NF.CD_VD = PDV_VD.CD_VD
	LEFT JOIN EST_NF_ENT_NFE CONT_NF_NFE ON 
		CONT_NF.CD_EMP = CONT_NF_NFE.CD_EMP
		AND CONT_NF.CD_FILIAL = CONT_NF_NFE.CD_FILIAL
		AND CONT_NF.CD_NF = CONT_NF_NFE.CD_NF
	LEFT OUTER JOIN(
		SELECT 
			CD_EMP,
			CD_FILIAL,
			VALOR
		FROM
			PRC_FILIAL_CONFIG
		WHERE
			CD_CHAVE = 'FLAG_NF_DEVO_REQUIS') Par ON 
		NCC_DEV.CD_EMP = Par.CD_EMP
		AND NCC_DEV.CD_FILIAL = Par.CD_FILIAL
	LEFT OUTER JOIN(
		SELECT 
			CD_EMP,
			CD_FILIAL,
			VALOR
		FROM
			PRC_FILIAL_CONFIG
		WHERE
			CD_CHAVE = 'FLAG_NF_DEVO_REQUIS_NFE') ParNfe ON 
		NCC_DEV.CD_EMP = ParNfe.CD_EMP
		AND NCC_DEV.CD_FILIAL = ParNfe.CD_FILIAL
);
